<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Subscribers;

use Shopware\Plugins\ViisonCommon\Structs;

// phpcs:ignore VIISON.Classes.AbstractClassName
abstract class CompatibilityCheck extends AbstractBaseSubscriber
{
    /**
     * Returns the plugins compatibility constraints.
     *
     * Example of an implementation:
     *
     *     public function getPluginCompatibilityConstraints()
     *         return array(
     *             new \Shopware\Plugins\ViisonCommon\Structs\PluginCompatibilityConstraint(
     *                 'Core',
     *                 'ViisonFoo',
     *                 '1.12.0' // minimum required version
     *             )
     *         );
     *     }
     *
     * @return Shopware\Plugins\ViisonCommon\Structs\PluginCompatibilityConstraint[]
     */
    abstract public function getPluginCompatibilityConstraints();

    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            'ViisonCommon_CheckCompatibilityConstraints' => 'onCheckCompatibilityConstraints',
        ];
    }

    /**
     * Checks the plugins compatibility constraints.
     *
     * @param \Enlight_Event_EventArgs $args
     */
    public function onCheckCompatibilityConstraints(\Enlight_Event_EventArgs $args)
    {
        $constraints = new Structs\Collection($this->getPluginCompatibilityConstraints());
        foreach ($constraints as $constraint) {
            $this->getContainer()->get('ViisonCommonCompatibilityCheck')->checkConstraint(
                $this->getPluginBootstrap()->getName(),
                $constraint
            );
        }
    }
}
