<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Subscribers;

// phpcs:ignore VIISON.Classes.AbstractClassName
abstract class Controllers extends AbstractBaseSubscriber
{
    /**
     * The modules, for which controllers can be provided using a subclass of this subscriber.
     */
    const MODULE_FRONTEND = 'Frontend';
    const MODULE_BACKEND = 'Backend';
    const MODULE_API = 'Api';

    /**
     * Returns an associative array of module names (MODULE_FRONTEND, MODULE_BACKEND or MODULE_API)
     * as keys and arrays of plain controller names as values. That is, if the full namespaced
     * name of an API controller is 'Shopware_Controllers_Api_ViisonCommonController', the plain
     * controller name is 'ViisonCommonController'. An simple implementation of this method could
     * look like the following:
     *
     *  return array(
     *      static::MODULE_API => array(
     *          'ViisonCommonController'
     *      )
     *  );
     *
     * @return array
     */
    public static function getControllerNames()
    {
        return [];
    }

    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        // Dynamically create the event names based on the module and controller names
        $events = [];
        foreach (static::getControllerNames() as $moduleName => $controllerNames) {
            $eventNamePrefix = 'Enlight_Controller_Dispatcher_ControllerPath_';
            $eventNamePrefix .= $moduleName . '_';
            foreach ($controllerNames as $controllerName) {
                $events[$eventNamePrefix . $controllerName] = 'onGetCustomControllerPath';
            }
        }

        return $events;
    }

    /**
     * Creates a new instance of the service class that is mapped to the requested
     * service name.
     *
     * @param \Enlight_Event_EventArgs $args
     * @return mixed
     */
    public function onGetCustomControllerPath(\Enlight_Event_EventArgs $args)
    {
        return $this->getPluginPath() . 'Controllers/' . ucfirst($args->getRequest()->getModuleName()) . '/' . $args->getRequest()->getControllerName() .'.php';
    }
}
