<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Subscribers;

use Shopware\Plugins\ViisonCommon\Subscribers\Common;

class IndexPopupWindowQueue extends AbstractBaseSubscriber
{
    /**
     * @var string $indexPopupWindowSubAppName
     */
    private $indexPopupWindowSubAppName;

    /**
     * @var int $indexPopupWindowPosition
     */
    private $indexPopupWindowPosition;

    /**
     * @param \Shopware_Components_Plugin_Bootstrap $pluginBootstrap
     * @param string $indexPopupWindowSubAppName
     * @param int $indexPopupWindowPosition (optional)
     */
    public function __construct(\Shopware_Components_Plugin_Bootstrap $pluginBootstrap, $indexPopupWindowSubAppName, $indexPopupWindowPosition = 0)
    {
        parent::__construct($pluginBootstrap);
        $this->indexPopupWindowSubAppName = $indexPopupWindowSubAppName;
        $this->indexPopupWindowPosition = $indexPopupWindowPosition;
    }

    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base::getSubscribedEvents()
     */
    public static function getSubscribedEvents()
    {
        return [
            Common::EVENT_COLLECT_INDEX_POPUP_WINDOWS => 'onCollectIndexPopupWindows',
        ];
    }

    /**
     * Returns the sub app name and position of this subscriber.
     *
     * @param \Enlight_Event_EventArgs $args
     */
    public function onCollectIndexPopupWindows(\Enlight_Event_EventArgs $args)
    {
        return [
            $this->indexPopupWindowSubAppName,
            $this->indexPopupWindowPosition,
        ];
    }
}
