<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\FileStorage;

use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\Util\Util as ViisonCommonUtil;

class FileStorageServiceFactory
{
    /**
     * @var Container
     */
    private $container;

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * Returns a new instance of FileStorage for saving document files to the correct location.
     *
     * The kind of storage and the location where the documents are saved differ from SW version to SW version.
     *
     * @return FileStorage
     */
    public function createDocumentFileStorageService()
    {
        if (ViisonCommonUtil::assertMinimumShopwareVersion('5.5')) {
            return new FlysystemFileStorage($this->container->get('shopware.filesystem.private'), 'documents');
        }
        if (ViisonCommonUtil::assertMinimumShopwareVersion('5.4')) {
            return new LocalDirectoryFileStorage($this->container->getParameter('shopware.app.documentsDir'));
        }

        return new LocalDirectoryFileStorage($this->container->getParameter('kernel.root_dir') . '/files/documents');
    }
}
