<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\Migration;

use Shopware_Components_Plugin_Bootstrap;

/**
 * Subscriber that listens to the migration collection event of the MigrationService.
 *
 * Implement this subscriber if your plugin has migrations.
 *
 * Example implementation:
 * <code>
 * class MyPluginMigrationSubscriber extends AbstractPluginMigrationSubscriber
 * {
 *     // ...
 *
 *     /**
 *      * @inheritdoc
 *      * /
 *     public function createMigrations()
 *     {
 *         $this->addMigration('sampleMigration', new SampleMigration($this->get('db')));
 *         $this->addMigration('anotherSampleMigration', new AnotherSampleMigration($this->get('db')));
 *     }
 * }
 * </code>
 */
abstract class AbstractPluginMigrationSubscriber extends AbstractMigrationSubscriber
{
    /**
     * @param Shopware_Components_Plugin_Bootstrap $pluginBootstrap
     */
    public function __construct(Shopware_Components_Plugin_Bootstrap $pluginBootstrap)
    {
        parent::__construct($pluginBootstrap->getName(), $pluginBootstrap->Application()->Container());
    }
}
