<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\Migration;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class MigrationInProgressException extends \Exception implements LocalizableThrowable
{
    use MessageLocalization;

    public function __construct()
    {
        parent::__construct(
            'There is currently another migration process in progress. Please wait a few seconds and try again.'
        );

        $this->setSnippetName('migrationInProgress');
        $this->setSnippetNamespace('exceptions/viison_common/migration_exception');
    }
}
