<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationBuilder;

use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplication;
use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationCodeGenerator\SubApplicationCodeGeneratorFactoryService;
use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationRegistry;

/**
 * Builder to create a SubApplication that can be requested via backend controller or is just a dependency for other
 * SubApplications.
 *
 * This class is a wrapper providing a fluent API for the SubApplication configuration.
 */
class StandaloneSubApplicationBuilder extends AbstractSubApplicationBuilder
{
    use SubApplicationDependent;

    /**
     * @inheritdoc
     */
    public function registerInSubApplicationRegistry(
        SubApplicationRegistry $subApplicationRegistry,
        SubApplicationCodeGeneratorFactoryService $subApplicationCodeGeneratorFactory
    ) {
        $codeGenerator = $subApplicationCodeGeneratorFactory->createPlainSubApplicationCodeGenerator(
            $this->name,
            $this->pluginPath,
            $this->controllerClassName
        );
        $subApplication = new SubApplication($this->name, $codeGenerator);
        $subApplication->addDependencyNames($this->namesOfRequiredSubApplications);
        $subApplicationRegistry->registerSubApplication($subApplication);
    }
}
