<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationBuilder;

/**
 * Use this to create a builder that build a SubApplication that can have dependencies.
 */
trait SubApplicationDependent
{
    /**
     * @var array Names of required SubApplications
     */
    private $namesOfRequiredSubApplications = [];

    /**
     * Mark the SubApplication as depending on another SubApplication.
     *
     * Instruct the JSLoader to automatically load the SubApplications given by the $namesOfRequiredSubApplications
     * together with this SubApplication.
     *
     * @param string[] $namesOfRequiredSubApplications
     * @return self
     */
    public function requiringSubApplications(array $namesOfRequiredSubApplications)
    {
        $this->namesOfRequiredSubApplications = array_merge(
            $this->namesOfRequiredSubApplications,
            $namesOfRequiredSubApplications
        );

        return $this;
    }

    /**
     * Make the SubApplication dependent of other SubApplications.
     *
     * Instruct the JSLoader to automatically load the SubApplications given by the $namesOfRequiredSubApplications
     * together with this SubApplication.
     *
     * @param string $namesOfRequiredSubApplications
     * @return self
     */
    public function requiringSubApplication($namesOfRequiredSubApplications)
    {
        $this->namesOfRequiredSubApplications[] = $namesOfRequiredSubApplications;

        return $this;
    }
}
