<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\SubApplicationCodeGenerator;

use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Components\ControllerFactoryService;

class SubApplicationCodeGeneratorFactoryService
{
    /**
     * @var Container
     */
    private $dependencyContainer;

    /**
     * @var \Enlight_Controller_Front
     */
    private $frontController;

    /**
     * @var \Enlight_Loader
     */
    private $classLoader;

    /**
     * @var \Enlight_Event_EventManager
     */
    private $eventEventManager;

    /**
     * @var \Zend_Db_Adapter_Abstract
     */
    private $db;

    /**
     * @var \Shopware_Components_Snippet_Manager
     */
    private $snippetManager;

    /**
     * @var \Enlight_Plugin_PluginManager
     */
    private $pluginManager;

    /**
     * @var ControllerFactoryService
     */
    private $controllerFactoryService;

    /**
     * @param Container $dependencyContainer
     * @param \Enlight_Controller_Front $frontController
     * @param \Enlight_Loader $classLoader
     * @param \Enlight_Event_EventManager $eventEventManager
     * @param ControllerFactoryService $controllerFactoryService
     * @param \Zend_Db_Adapter_Abstract $db
     * @param \Shopware_Components_Snippet_Manager $snippetManager
     * @param \Enlight_Plugin_PluginManager $pluginManager
     */
    public function __construct(
        Container $dependencyContainer,
        \Enlight_Controller_Front $frontController,
        \Enlight_Loader $classLoader,
        \Enlight_Event_EventManager $eventEventManager,
        ControllerFactoryService $controllerFactoryService,
        \Zend_Db_Adapter_Abstract $db,
        \Shopware_Components_Snippet_Manager $snippetManager,
        \Enlight_Plugin_PluginManager $pluginManager
    ) {
        $this->dependencyContainer = $dependencyContainer;
        $this->frontController = $frontController;
        $this->classLoader = $classLoader;
        $this->eventEventManager = $eventEventManager;
        $this->controllerFactoryService = $controllerFactoryService;
        $this->db = $db;
        $this->snippetManager = $snippetManager;
        $this->pluginManager = $pluginManager;
    }

    /**
     * @param string $name
     * @param string $path
     * @param string $controllerClass
     * @return SmartySubApplicationCodeGenerator
     */
    public function createSmartySubApplicationCodeGenerator($name, $path, $controllerClass)
    {
        return new SmartySubApplicationCodeGenerator(
            $this->dependencyContainer,
            $this->frontController,
            $this->classLoader,
            $this->eventEventManager,
            $this->controllerFactoryService,
            $this->pluginManager,
            $name,
            $path,
            $controllerClass
        );
    }

    /**
     * @param string $name
     * @param string $path
     * @param string $controllerClass
     * @return PlainSubApplicationCodeGenerator
     */
    public function createPlainSubApplicationCodeGenerator($name, $path, $controllerClass)
    {
        return new PlainSubApplicationCodeGenerator(
            $this->dependencyContainer,
            $this->frontController,
            $this->classLoader,
            $this->eventEventManager,
            $this->controllerFactoryService,
            $this->db,
            $this->snippetManager,
            $name,
            $path,
            $controllerClass
        );
    }

    /**
     * @return EmptySubApplicationCodeGenerator
     */
    public function createEmptySubApplicationCodeGenerator()
    {
        return new EmptySubApplicationCodeGenerator();
    }
}
