<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/*
 * Exclude this file from ionCube encryption, because the proxy manager cannot use reflection to access all information
 * of encrypted files. In particular, an exception is thrown then trying to generate the hook proxy method for
 * 'createMail()', whose parameter '$context' has a default value, which is inaccessible.
 *
 * @Shopware\noEncryption
 */
namespace Shopware\Plugins\ViisonCommon\Components;

/**
 * A decorator for \Shopware_Components_TemplateMail that just adds the implementation of the interface \Enlight_Hook
 * to the service 'templatemail'.
 *
 * This is necessary because Shopwares \Shopware_Components_TemplateMail is not hookable by default. This decorator
 * adds the hookability to the component. In your subscribers you need to hook this class instead of
 * \Shopware_Components_TemplateMail.
 */
class TemplateMailServiceDecorator extends \Shopware_Components_TemplateMail implements \Enlight_Hook
{
    /**
     * @var \Shopware_Components_TemplateMail
     */
    private $decoratedInstance;

    /**
     * @param \Shopware_Components_TemplateMail $decoratedInstance
     * @return TemplateMailServiceDecorator
     */
    public static function decorate(\Shopware_Components_TemplateMail $decoratedInstance)
    {
        /** @var self $decorator */
        $decorator = \Enlight_Class::Instance(__CLASS__);
        $decorator->decoratedInstance = $decoratedInstance;

        return $decorator;
    }

    // Overwrite all method to call them on the decorated instance instead of the parent. This is how the decorator
    // pattern works...

    /**
     * @inheritdoc
     */
    public function setModelManager(\Shopware\Components\Model\ModelManager $modelManager)
    {
        return $this->decoratedInstance->setModelManager($modelManager);
    }

    /**
     * @inheritdoc
     */
    public function getModelManager()
    {
        return $this->decoratedInstance->getModelManager();
    }

    /**
     * @inheritdoc
     */
    public function setShop($shop)
    {
        return $this->decoratedInstance->setShop($shop);
    }

    /**
     * @inheritdoc
     */
    public function getShop()
    {
        return $this->decoratedInstance->getShop();
    }

    /**
     * @inheritdoc
     */
    public function getTranslationReader()
    {
        return $this->decoratedInstance->getTranslationReader();
    }

    /**
     * @inheritdoc
     */
    public function setTranslationReader($translationReader)
    {
        return $this->decoratedInstance->setTranslationReader($translationReader);
    }

    /**
     * @inheritdoc
     */
    public function setStringCompiler(\Shopware_Components_StringCompiler $stringCompiler)
    {
        return $this->decoratedInstance->setStringCompiler($stringCompiler);
    }

    /**
     * @inheritdoc
     */
    public function getStringCompiler()
    {
        return $this->decoratedInstance->getStringCompiler();
    }

    /**
     * @inheritdoc
     */
    public function createMail($mailModel, $context = [], $shop = null, $overrideConfig = [])
    {
        return $this->decoratedInstance->createMail($mailModel, $context, $shop, $overrideConfig);
    }

    /**
     * @inheritdoc
     */
    public function loadValues(\Enlight_Components_Mail $mail, \Shopware\Models\Mail\Mail $mailModel, $overrideConfig = [])
    {
        return $this->decoratedInstance->loadValues($mail, $mailModel, $overrideConfig);
    }
}
