<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;
use Doctrine\Common\Collections\ArrayCollection;

class Shopware_Controllers_Backend_ViisonCommonConfigDocument extends ViisonCommonBaseController
{
    /**
     * @override
     *
     * Fetches all document names of document templates that need to be protected (disable the copy-to-all layout
     * button)
     *
     * @return array
     */
    public function getViewParams()
    {
        // Allow other plugins to overwrite the parameters
        $protectedDocumentNames = $this->get('events')->collect(
            'ViisonCommon_collectProtectedDocumentNames',
            new ArrayCollection([])
        )->toArray();

        return [
            'relevantDocumentNames' => $protectedDocumentNames,
        ];
    }
}
