<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Subscribers\Components;

use Enlight\Event\SubscriberInterface;
use Enlight_Hook_HookArgs;

/**
 * This subscriber must be added to the event manager to ensure that hook proxies for
 * {@link Shopware_Components_Document::saveDocument()} as well as
 * {@link Shopware_Models_Document_Order::processPositions()} are created. This allows to use one-off hook listeners
 * as registered by {@link Shopware\Plugins\ViisonCommon\Components\DocumentComponentListenerService}.
 */
class DocumentComponentDummySubscriber implements SubscriberInterface
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Components_Document::saveDocument::after' => 'dummyHookMethod',
            'Shopware_Components_Document::saveDocument::before' => 'dummyHookMethod',
            'Shopware_Models_Document_Order::processPositions::before' => 'dummyHookMethod',
        ];
    }

    /**
     * @return Enlight_Hook_HookArgs $args
     */
    public function dummyHookMethod(Enlight_Hook_HookArgs $args)
    {
        // Don't do anything here
    }
}
