// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.ArticleCategoryFactory', {

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_common_analytics/main',

    constructor: function (config) {
        if (!config.store) {
            throw new Error('Needs a store');
        }
        this.config = Object.create(null, {
            store: {
                value: config.store,
                enumerable: true,
            },
        });

        this.callParent(arguments);
    },

    getToolbarComponentValueRetriever: function () {
        return function (toolbar) {
            return toolbar.child('[name=viison_pickware_erp_analytics_article_category_selection]').getValue();
        };
    },

    getToolbarFilterConfig: function () {
        return {
            componentConfig: Ext.apply(
                {
                    xtype: 'combobox',
                    iconCls: 'sprite-gear',
                    name: 'viison_pickware_erp_analytics_article_category_selection',
                    queryMode: 'remote',
                    fieldLabel: this.getViisonSnippet('toolbar/article_category'),
                    displayField: 'name',
                    valueField: 'id',
                    labelWidth: 70,
                },
                this.config
            ),
        };
    },

});
