// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.ModuleWithFilter', {

    extend: 'Shopware.apps.ViisonCommonAnalytics.controller.AnalysisModuleHandler',

    constructor: function (config) {
        this.setFilterModules(config.filterModules);
        this.callParent(arguments);
    },

    setFilterModules: function (filterModules) {
        this.filterModules = filterModules || {};
        this.toolbarComponents = null;
        this.valueRetrievers = null;
    },

    initializeFilterModules: function () {
        var toolbarComponents = {};
        var valueRetrievers = {};

        Ext.Object.each(this.filterModules, function (paramName, filterModule) {
            var factoryClass = filterModule.factoryClass;
            var moduleFactoryConfig = filterModule.factoryConfig;
            var factoryConfig = Ext.applyIf({}, moduleFactoryConfig);
            var factory = Ext.create(factoryClass, factoryConfig);
            var toolbarComponent = factory.getToolbarFilterConfig();
            toolbarComponents[paramName] = toolbarComponent;
            valueRetrievers[paramName] = factory.getToolbarComponentValueRetriever();
        });

        this.toolbarComponents = toolbarComponents;
        this.valueRetrievers = valueRetrievers;
    },

    getToolbarComponents: function () {
        if (this.toolbarComponents === null) {
            this.initializeFilterModules();
        }

        return this.toolbarComponents;
    },

    getValueRetriever: function (paramName) {
        if (this.valueRetrievers === null) {
            this.initializeFilterModules();
        }

        return this.valueRetrievers[paramName];
    },

    onLeaveAnalysis: function (mainController, nextStore, nextRecord, analysis, nextAnalysis) {
        if (nextAnalysis === null) {
            // nextAnalysis is an ordinary Shopware analysis, not an AnalyticsCommon module.
            var toolbar = mainController.viisonCommonAnalyticsGetToolbar();
            var refreshedCallback = mainController.viisonCommonAnalyticsOnToolbarRefreshed.bind(mainController);
            toolbar.viisonCommonAnalyticsRestoreToolbarComponents(refreshedCallback);
        }

        return this.callParent(arguments);
    },

    onBeforeRenderDataOutput: function (mainController) {
        var toolbar = mainController.viisonCommonAnalyticsGetToolbar();
        var refreshedCallback = mainController.viisonCommonAnalyticsOnToolbarRefreshed.bind(mainController);
        toolbar.viisonCommonAnalyticsSetToolbarComponents(this.getToolbarComponents(), refreshedCallback);

        return this.callParent(arguments);
    },

    onBuildRequestParamMap: function (mainController, analysis, paramMap) {
        var toolbar = mainController.viisonCommonAnalyticsGetToolbar();
        Ext.Object.each(this.filterModules, function (paramName) {
            var retrieveValue = this.getValueRetriever(paramName);
            paramMap[paramName] = retrieveValue(toolbar);
        }, this);

        return this.callParent(arguments);
    },

});
