// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.ModuleWithImprovedToolbar', {

    extend: 'Shopware.apps.ViisonCommonAnalytics.controller.AnalysisModuleHandler',

    onLeaveAnalysis: function (mainController, nextStore, nextRecord, analysis, nextAnalysis) {
        if (nextAnalysis === null) {
            // nextAnalysis is an ordinary Shopware analysis, not an AnalyticsCommon module.
            var toolbar = mainController.viisonCommonAnalyticsGetToolbar();
            var refreshedCallback = mainController.viisonCommonAnalyticsOnToolbarRefreshed.bind(mainController);
            toolbar.viisonCommonAnalyticsRestoreToolbar(refreshedCallback);
        }

        return this.callParent(arguments);
    },

    onBeforeRenderDataOutput: function (mainController) {
        var toolbar = mainController.viisonCommonAnalyticsGetToolbar();
        var refreshedCallback = mainController.viisonCommonAnalyticsOnToolbarRefreshed.bind(mainController);
        toolbar.viisonCommonAnalyticsImproveToolbar(refreshedCallback);

        return this.callParent(arguments);
    },

});
