// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonAnalytics.view.main.TableHelpers', {

    percentageRenderer: function (value) {
        if (typeof value === 'string') {
            value = parseFloat(value);
        }

        // If no percentage value (e.g. null, NaN) was provided, return '-' to display no value in the backend.
        if (Number.isNaN(value) || typeof value !== 'number') {
            return '-';
        }

        // Use Ext.util.Format.number formatting to get localized percentage decimal separator (,/.)
        return Ext.util.Format.number((Math.round(value * 100 * 100) / 100).toFixed(2), '0.00') + '\u202F%';
    },

});
