// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonCommonMigration.store.MigrationSet', {
    extend: 'Ext.data.Store',

    model: 'Shopware.apps.ViisonCommonMigration.model.MigrationSet',
    sorters: [
        { property: 'name' },
    ],

    /**
     * @override
     */
    loadData: function (migrationSetsData, append) {
        if (!append) {
            this.removeAll();
        }

        migrationSetsData.forEach(function (migrationSetData) {
            var migrationSet = Ext.create(this.model, migrationSetData);
            migrationSet.getMigrations().loadData(migrationSetData.migrations);
            this.add(migrationSet);
        }, this);
    },
});
