<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * @deprecated This check is obsolete and should not be used anymore!
 *
 * Checks all plugins, which have been releast containing incompatible ViisonCommon versions,
 * for an incompatible ViisonCommon version and, if found, throws an exception. Use this method
 * only at the beginning of a plugin's 'update()' method! By throwing the exception the user
 * is presented a growl notification containing the exception message and the plugin gets disabled.
 * See also the 'Version.php' file for further info.
 *
 * @param string $updatingPluginName
 * @throws \Exception If an incompatible ViisonCommon version was found.
 */
return function ($updatingPluginName) {
    $plugins = [
        'ViisonPickwareConnector' => [
            'Core',
            'Pickware Backend',
        ],
        'ViisonPickwareERP' => [
            'Core',
            'Shopware ERP powered by Pickware',
        ],
        'ViisonDATEV' => [
            'Backend',
            'DATEV Export',
        ],
    ];
    foreach ($plugins as $incompatiblePluginName => $pluginInfo) {
        // Check for a 'RealVersion.php' file first (only contained in compatible versions)
        $viisonCommonBasePath = __DIR__ . '/../../../' . $pluginInfo[0] .'/' . $incompatiblePluginName . '/ViisonCommon';
        $viisonCommonVersionPath = $viisonCommonBasePath . '/RealVersion.php';
        if (!file_exists($viisonCommonVersionPath)) {
            // No 'RealVersion.php' file found, hence use the old 'Version.php' file
            $viisonCommonVersionPath = $viisonCommonBasePath . '/Version.php';
            if (!file_exists($viisonCommonVersionPath)) {
                return;
            }
        }
        // Check for incompatible version
        $viisonCommonVersion = include($viisonCommonVersionPath);
        if (version_compare($viisonCommonVersion, '2.36.0', '<=')) {
            throw new \Exception(
                sprintf('Das Update des Plugins "%s" wurde abgebrochen und das Plugin deaktiviert. Bitte aktualisieren Sie zunächst das Plugin "%s" auf die neueste Version und versuchen Sie es anschließend erneut.', $updatingPluginName, $pluginInfo[1])
            );
        }
    }
};
