<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonUPS\Classes;

use Shopware\Plugins\ViisonShippingCommon\Classes\ShippingUtil as ShippingCommonUtil;
use Shopware\Plugins\ViisonUPS\Util;

/**
 * Provides shipping specific utility functions. Implements the ShippingUtil interface from the
 * ShippingCommon module.
 */
class ShippingUtil extends ShippingCommonUtil
{

    public function __construct()
    {
        parent::__construct(Util::instance());
    }

    /**
     * Sends a request to the dispatch service provider to download the document of the given type
     * with the given tracking code and save it to the given file path.
     *
     * UPS does not support loading labels that have been previously created, therefore this method
     * always returns null.
     *
     * @override
     * @param string $docType
     * @param string $trackingCode
     * @param string $path The file path where the document should be saved.
     * @return string A file containing the document.
     * @throws \Exception if the operation was not successful or is generally not supported by the dispatch service provider.
     */
    protected function loadDocumentFromDispatchServiceProvider($docType, $trackingCode, $path)
    {
        throw new \Exception('UPS does not allow to load documents after they were created');
    }

    /**
     * @Override
     */
    public function getProductOptions($productId)
    {
        return array();
    }
}
