<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonUPS\Classes;

class VoidShipmentRequest
{
    /*
     * The tracking number of the shipment that should be deleted.
     */
    private $shipmentIdentificationNumber;

    /**
     * The main constructor creating all necessary parts for the request body.
     *
     * @param string $shipmentIdentificationNumber
     */
    public function __construct($shipmentIdentificationNumber)
    {
        $this->shipmentIdentificationNumber = $shipmentIdentificationNumber;
    }

    public function getBody()
    {
        $body = array(
            'Request' => array(
                'RequestAction' => 'Void'
            ),
            /*'TransactionReference' => array(
                'CustomerContext' => $customerContext,
            )*/
            'ShipmentIdentificationNumber' => $this->shipmentIdentificationNumber
        );

        return $body;
    }
}
