<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonUPS\Components;

use Shopware\Plugins\ViisonShippingCommon\Components\Logger\AbstractHttpLogger;

class UpsHttpLogger extends AbstractHttpLogger
{
    /**
     * @inheritDoc
     */
    public function filterSensitiveData($content)
    {
        try {
            // Content might contain multiple xml documents with each their own header, process them individually
            $xmlParts = explode('<?xml version="1.0"?>', $content);

            // asXML() takes care of adding <xml> tags, we do not need to add them here
            return implode('', array_map(function ($xmlPart) {
                if (!$xmlPart) {
                    return $xmlPart;
                }

                $xml = new \SimpleXMLElement($xmlPart);

                if ($xml->AccessLicenseNumber) {
                    $xml->AccessLicenseNumber = '*HIDDEN*';
                }
                if ($xml->Password) {
                    $xml->Password = '*HIDDEN*';
                }

                return $xml->asXML();
            }, $xmlParts));
        } catch (\Exception $e) {
            return 'Could not parse XML. XML is truncated for security reasons. You can enable sensitive logging to disable truncating.';
        }
    }
}
