<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonShippingCommon\Classes\ShippingProvider;
use Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonConfig;
use Shopware\Plugins\ViisonUPS\Util;

/**
 * This controller adds some actions called in the config backend controller.
 * These actions are responsible for creating, updating and deleting custom configurations
 * of the UPS Adapter which are associated with (sub-)shop configurations.
 */
class Shopware_Controllers_Backend_ViisonUPSConfig extends ViisonShippingCommonConfig
{
    public function __construct(Enlight_Controller_Request_Request $request = null, Enlight_Controller_Response_Response $response = null)
    {
        parent::__construct($request, $response, Util::instance());
    }

    /**
     * @inheritdoc
     */
    public function getViewParams()
    {
        return array_merge(
            parent::getViewParams(),
            [
                'viisonGdprConfig' => [
                    'never' => ShippingProvider::GDPR_NEVER,
                    'always' => ShippingProvider::GDPR_ALWAYS,
                    'customerChoice' => ShippingProvider::GDPR_CUSTOMER_CHOICE,
                ],
            ]
        );
    }

    /**
     * @inheritdoc
     */
    protected function getSecretFields()
    {
        return ['password'];
    }

    /**
     * Returns an array containing all field keys that should be stored encrypted.
     * @return array
     */
    protected function getEncryptedFields()
    {
        return array();
    }

    /**
     * Returns an array that assigns functions to configuration field keys. These functions are passed newly
     * entered configuration values before the respective values are stored in the database. Fields whose key
     * is not contained in this array are stored unchanged.
     * @return array
     */
    protected function getPreProcessingFields()
    {
        return array();
    }
}
