<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonShippingCommon\Controllers\Backend\ViisonShippingCommonShipping;
use Shopware\Plugins\ViisonUPS\Classes\PluginInfo;

/**
 * This controller adds some actions called in the shipping backend controller.
 * These actions are responsible for creating, updating and deleting associations
 * between dispatch methods and available UPS products.
 */
class Shopware_Controllers_Backend_ViisonUPSShipping extends ViisonShippingCommonShipping
{

    public function __construct(Enlight_Controller_Request_Request $request = null, Enlight_Controller_Response_Response $response = null)
    {
        parent::__construct($request, $response, new PluginInfo());
    }

    /**
    * @override
    * @return array The columns of the product table that should be used for the ordering of the products (e.g. in comboboxes where a product can be chosen).
    */
    protected function getProductColumnOrder()
    {
        return array('code');
    }

    /**
     * Gathers all UPS packaging codes and returns them in a list.
     */
    public function getPackagingTypesAction()
    {
        // Get all dispatch service provider products
        $packagingTypeTable = new \Zend_Db_Table('s_viison_ups_packaging_codes');
        $packagingTypes = $packagingTypeTable->fetchAll($packagingTypeTable->select())->toArray();

        // Return result
        $this->View()->assign(array(
            'success' => true,
            'data' => $packagingTypes
        ));
    }

    /**
     * @override
     */
    protected function getCustomMappingAttributes()
    {
        return array('additionalHandlingRequired', 'higherInsurance');
    }
}
