<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonUPS\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

// Because Shopware doesn't allow that Controllers use the new PSR-4 namespace standard
// we need to require the class, because of Enlight_Class::Instance
require_once(__DIR__ . '/../../Controllers/Backend/ViisonUPSOrder.php');

class ViisonShippingCommonOrder extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return array(
            'Shopware_Controllers_Backend_ViisonShippingCommonOrder_GetMergedLabelsAction' => 'onShippingCommonOrderGetMergedLabelsAction'
        );
    }

    /**
     * Add UPS label PDFs to the pdf list requested by the ViisonShippingCommonOrder_GetMergedLabels filter event.
     *
     * @param \Enlight_Event_EventArgs $arguments
     * @return array
     */
    public function onShippingCommonOrderGetMergedLabelsAction(\Enlight_Event_EventArgs $args)
    {
        $controller = $this->createViisonUPSOrderController($args);
        $trackingCodes = $args->getSubject()->Request()->getParam('trackingCodes', null);

        return array_merge($args->getReturn(), $controller->getLabelPDFs($trackingCodes));
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     * @return \Enlight_Class
     */
    private function createViisonUPSOrderController(\Enlight_Event_EventArgs $args)
    {
        return $this->get('viison_common.controller_factory_service')->getController(
            'Shopware_Controllers_Backend_ViisonUPSOrder',
            $args->getSubject()->Request(),
            $args->getSubject()->Response()
        );
    }
}
