<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonUPS\Subscribers;

use Monolog\Logger;
use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\LoggerFactory;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as AbstractServicesSubscriber;
use Shopware\Plugins\ViisonUPS\Components\UpsHttpLogger;

class ServicesSubscriber extends AbstractServicesSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getServices()
    {
        return [
            'viison_ups.logger' => function (Container $container) {
                // Make log level configurable via config.php:
                // 'viisonUPS' => [
                //     'logger' => [
                //         'level' => Logger::DEBUG,
                //     ],
                // ],
                $environment = $container->getParameter('kernel.environment');
                // The "shopware." prefix is added by Shopware
                if ($container->hasParameter('shopware.viisonups.logger.level')) {
                    $logLevel = $container->getParameter('shopware.viisonups.logger.level');
                } else {
                    $logLevel = ($environment === 'production') ? Logger::INFO : Logger::DEBUG;
                }
                $loggerFactory = new LoggerFactory($container);

                return $loggerFactory->createLikePluginLogger('ups', $logLevel);
            },
            'viison_ups.http_logger' => function (Container $container) {
                $upsHttpLogger = new UpsHttpLogger($container->get('viison_ups.logger'));
                // Make log level configurable via config.php:
                // 'viisonUPS' => [
                //     'httpLogger' => [
                //         'sensitive' => true,
                //     ],
                // ],
                if ($container->hasParameter('shopware.viisonups.httpLogger.sensitive')
                    && $container->getParameter('shopware.viisonups.httpLogger.sensitive')
                ) {
                    $upsHttpLogger->setLogSensitiveData(true);
                }

                return $upsHttpLogger;
            },
        ];
    }
}
