<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonUPS\Subscribers;

class SubApplicationRegistration extends \Shopware\Plugins\ViisonCommon\Classes\Subscribers\SubApplicationRegistration
{
    /**
     * @override
     */
    public function getSubApplications()
    {
        return array(
            'ViisonUPSConfig' => array(
                null,
                array(
                    'ViisonShippingCommonConfig',
                    'ViisonShippingCommonFreeFormLabels'
                )
            ),
            'ViisonUPSFreeFormLabels' => array(
                null,
                array(
                    'ViisonUPSOrder',
                    'ViisonShippingCommonFreeFormLabels'
                )
            ),
            'ViisonUPSOrder' => array(
                'Order',
                array(
                    'ViisonUPSShipping',
                    'ViisonShippingCommonOrder'
                )
            ),
            'ViisonUPSShipping' => array(
                'Shipping',
                array(
                    'ViisonShippingCommonShipping'
                )
            )
        );
    }
}
