// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name=backend/viison_ups_config/config}
Ext.define('Shopware.apps.ViisonUPSConfig.controller.Main', {

    extend: 'Shopware.apps.ViisonShippingCommonConfig.controller.Main',

    requires: 'Shopware.apps.ViisonUPSShipping',

    refs: [
        { ref: 'window', selector: 'viisonupsconfig-window' },
        { ref: 'panel', selector: 'viisonupsconfig-panel' }
    ],

    dispatchServiceProviderConfigModelClass: 'Shopware.apps.ViisonUPSConfig.model.UPS',

    /**
     * Contains all snippets for the view component.
     */
    snippets: {
        notifications: {
            saveConfigurationSuccess: {
                title: '{s name="main/notifications/save_configuration_success/title"}{/s}',
                message: '{s name="main/notifications/save_configuration_success/message"}{/s}'
            },
            saveConfigurationError: {
                title: '{s name="main/notifications/save_configuration_error/title"}{/s}',
                message: '{s name="main/notifications/save_configuration_error/message"}{/s}'
            },
            saveConfigurationValidationError: {
                title: '{s name="main/notifications/save_configuration_validation_error/title"}{/s}',
                message: '{s name="main/notifications/save_configuration_validation_error/message"}{/s}'
            },
            loadAllConfigurationsError: {
                title: '{s name="main/notifications/load_all_configurations_error/title"}{/s}',
                message: '{s name="main/notifications/load_all_configurations_error/message"}{/s}'
            },
            destroyConfigurationSuccess: {
                title: '{s name="main/notifications/destroy_configuration_success/title"}{/s}',
                message: '{s name="main/notifications/destroy_configuration_success/message"}{/s}'
            },
            destroyConfigurationError: {
                title: '{s name="main/notifications/destroy_configuration_error/title"}{/s}',
                message: '{s name="main/notifications/destroy_configuration_error/message"}{/s}'
            },
            growlMessage: '{s name="main/notifications/growlMessage"}{/s}'
        }
    },

    constructor: function() {
        this.configStore = Ext.create('Shopware.apps.ViisonUPSConfig.store.UPS');
        this.callParent(arguments);
    }

});
