// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single UPS configuration.
 */
Ext.define('Shopware.apps.ViisonUPSConfig.model.UPS', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Model',

    /**
     * The fields used for this model.
     *
     * NOTE: Dynamic model rendering via getViewParams()
     */
    fields: [].concat({$shippingConfigFields|@json_encode} || []),

    /**
     * Configure the data communication.
     */
    proxy: {
        type: 'ajax',
        api: {
            create: '{url controller="ViisonUPSConfig" action="createConfiguration"}',
            update: '{url controller="ViisonUPSConfig" action="updateConfiguration"}',
            destroy: '{url controller="ViisonUPSConfig" action="destroyConfiguration"}'
        },
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total'
        }
    }

});
