// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling all UPS configuration objects.
 */
Ext.define('Shopware.apps.ViisonUPSConfig.store.UPS', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Store',

    /**
     * Define the used model for this store.
     */
    model: 'Shopware.apps.ViisonUPSConfig.model.UPS',

    /**
     * The id used to find the store in the application.
     */
    storeId: 'viison-ups-config-store',

    /**
     * Configure the data communication.
     */
    proxy: {
        type: 'ajax',
        url: '{url controller="ViisonUPSConfig" action="getAllConfigurations"}',
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total'
        }
    }

});
