// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name=backend/viison_ups_free_form_labels/main}
Ext.define('Shopware.apps.ViisonUPSFreeFormLabels.controller.Main', {

    extend: 'Shopware.apps.ViisonShippingCommonFreeFormLabels.controller.Main',

    /**
     * Plugin-specific properties required by the parent class
     */
    dispatchServiceProviderPanelClass: 'viison-ups-free-form-labels-window',
    productStoreClass: 'Shopware.apps.ViisonUPSShipping.store.Product',
    labelConfirmPanelClass: 'Shopware.apps.ViisonUPSFreeFormLabels.view.LabelConfirm',
    shippingLabelClass: 'Shopware.apps.ViisonUPSOrder.model.ShippingLabel',
    dispatchServiceProviderLabelConfirmPanel: 'order-viison-ups-label-confirm-panel',
    labelPanelSelector:  'viison-ups-free-form-labels-window',
    sendMailURL: '{url controller="ViisonUPSOrder" action="sendMail"}',
    downloadDocumentsURL: '{url controller="ViisonUPSOrder" action="downloadDocuments"}',
    listDispatchActionsControllerClass: 'Shopware.apps.ViisonUPSOrder.controller.ListDispatchActions',
    orderConfigDataClass: 'Shopware.apps.ViisonUPSOrder.store.OrderConfigData',

    customSnippets: {
        notifications: {
            growlMessage: '{s name="main/notifications/growlMessage"}{/s}'
        }
    },

    /**
     * Set the default packaging type when opening the label confirm window
     * @override
     * @param dispatchServiceProviderTab
     * @param record
     * @param shippingLabelStore
     */
    onShowLabelConfirmWindow: function(dispatchServiceProviderTab, record, shippingLabelStore) {
        this.callParent(arguments);

        this.updatePackagingType();
    },

    /**
     * Loads the default packaging type from the backend controller. If already a label
     * confirm window and panel exist, it will be updated.
     */
    updatePackagingType: function() {
        var me = this;
        Ext.Ajax.request({
            url: '{url controller="ViisonUPSOrder" action="getDefaultPackagingType"}',
            params: {
                orderId: 0
            },
            success: function(response) {
                var data = Ext.JSON.decode(response.responseText);

                if (me.getLabelConfirmWindow() && me.getLabelConfirmWindow().dataPanel) {
                    me.getLabelConfirmPanel().defaultPackagingType = data.defaultPackagingType;
                    // Force update of displayed values in label confirm view
                    me.getLabelConfirmWindow().dataPanel.setValues();
                }
            }
        });
    }

});
