// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * TODO This file was copied from views/viison_ups_order/shipping_labels.js.
 * Because of the changed loading order of the Javascript code caused by the JSLoader, the override in the
 * original shipping_labels.js file does not apply anymore to this subapp. We should DRY this code again.
 */
//{namespace name="backend/viison_ups_order/order"}
Ext.define('Shopware.apps.ViisonUPSFreeFormLabels.controller.ShippingLabels', {

    override: 'Shopware.apps.ViisonShippingCommonOrder.controller.ShippingLabels',

    /**
     * Add the residential address, packaging type and insurance settings to the shipping label parameters.
     *
     * @override
     * @param details
     * @param packagingDetails
     * @param settings
     */
    getShippingLabelParams: function (record, details, packagingDetails, settings) {
        var params = this.callParent(arguments);
        params['detailsResidentialAddress'] = details.residentialAddress;
        if (settings) {
            params['settingsPackagingType'] = settings.packagingType;
            params['settingsAdditionalHandlingRequired'] = settings.additionalHandlingRequired;
            params['settingsHigherInsurance'] = settings.higherInsurance;
            params['settingsInsuredValue'] = settings.insuredValue;
            params['settingsInsuredValueCurrency'] = settings.insuredValueCurrency;
        }
        return params;
    }

});