// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A free form labels specific extension to the label confirm panel.
 */
//{namespace name="backend/viison_ups_free_form_labels/label_confirm"}
Ext.define('Shopware.apps.ViisonUPSFreeFormLabels.view.LabelConfirm', {
    extend: 'Shopware.apps.ViisonUPSOrder.view.detail.LabelConfirm',

    mixins: {
        freeFormLabels: 'Shopware.apps.ViisonShippingCommonFreeFormLabels.view.LabelConfirm'
    },

    /**
     * Returns additional containers to be added to the items of the label confirm panel.
     *
     * @return A list of containers.
     */
    createExtraContainers: function() {
        return this.callParent(arguments).concat(
            this.mixins.freeFormLabels.createExtraContainers.call(this, arguments)
        );
    },

    /**
     * Returns all plugin-specific extra key value pairs that should be sent to the PHP controller when
     * creating a label.
     *
     * @return An object containing the extra key value pairs
     */
    getExtraSettings: function() {
        return Ext.apply(
            this.callParent(arguments),
            this.mixins.freeFormLabels.getExtraSettings.call(this, arguments)
        );
    },

    updateExtraContainersVisibility: function() {
        return this.mixins.freeFormLabels.updateExtraContainersVisibility.call(this, arguments);
    }

});
