// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * Extend the default List controller to handle the batch label creation.
 */
//{namespace name="backend/viison_shipping_common_order/order"}
Ext.define('Shopware.apps.ViisonUPSOrder.controller.List', {

    /**
     * Override the default list controller or at least parts of it.
     */
    override: 'Shopware.apps.ViisonShippingCommonOrder.controller.ListDispatch',

    init: function() {
        this.callParent(arguments);
        this.addDispatchServiceProviderTabControllerClass('Shopware.apps.ViisonUPSOrder.controller.Tab');
        this.addListDispatchActionsControllerClass('Shopware.apps.ViisonUPSOrder.controller.ListDispatchActions');
    }

});
