// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * Extend the default List controller to handle the batch label creation.
 */
//{namespace name="backend/viison_ups_order/order"}

Ext.define('Shopware.apps.ViisonUPSOrder.controller.ListDispatchActions', {

    extend: 'Shopware.apps.ViisonShippingCommonOrder.controller.ListDispatchActions',

    /**
     * Plugin-specific properties required by the parent class
     */
    tabPanelAlias: 'order-viison-ups-tab',
    trackingURL: '{$pluginInfo->getTrackingURLForActiveLocale()}',
    trackingNumberDelimiter: '{$pluginInfo->getTrackingNumberDelimiter()}',
    downloadDocumentsURL: '{url controller="ViisonUPSOrder" action="downloadDocuments"}',

    /**
     * Returns if there is a product mapping for this order (for this dispatch service provider).
     *
     * @param orderRecord
     * @returns bool
     */
    hasProductMapping: function(orderRecord) {
        return orderRecord.raw.hasUPSDispatchMethod;
    },

    /**
     * Returns if there exists a label with a tracking code for an order from this dispatch service provider.
     *
     * @param orderRecord
     * @returns bool
     */
    hasTrackingCode: function(orderRecord) {
        return this.hasProductMapping(orderRecord); // TODO should check if there really is a UPS Label
    },

    /**
     * Returns the shipping label class of this dispatch service provider
     * @returns string
     */
    getShippingLabelClass: function() {
        return 'Shopware.apps.ViisonUPSOrder.model.ShippingLabel';
    }

});
