// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The model representing a single ShippingLabel as well as additional information
 * used to create one. This is necessary, because its not possible to add custom
 * parameters to a save() call.
 */
Ext.define('Shopware.apps.ViisonUPSOrder.model.ShippingLabel', {

    /**
     * Extend from the ShippingLabel model of the ShippingCommon module.
     */
    extend: 'Shopware.apps.ViisonShippingCommonOrder.model.ShippingLabel',

    /**
     * New plugin-specific fields.
     */
    fields: [
        { name: 'detailsResidentialAddress', type: 'boolean' },
        { name: 'settingsPackagingType', type: 'int' },
        { name: 'settingsAdditionalHandlingRequired', type: 'bool' },
        { name: 'settingsHigherInsurance', type: 'bool' },
        { name: 'settingsInsuredValue', type: 'float' },
        { name: 'settingsInsuredValueCurrency', type: 'string' },
        { name: 'settingsSaturdayDelivery', type: 'boolean', defaultValue: false },
    ],

    createURL: '{url controller="ViisonUPSOrder" action="createLabel"}',
    destroyURL: '{url controller="ViisonUPSOrder" action="destroyLabel"}'

});
