// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The main container of the dispatch service provider tab containing a button to open the LabelConfirmWindow
 * and a list of all existing shipping labels of the active record(order).
 */
//{namespace name="backend/viison_ups_order/order"}
Ext.define('Shopware.apps.ViisonUPSOrder.view.detail.Tab', {

    /**
     * Extend the order detail tab from the ShippingCommon module.
     */
    extend: 'Shopware.apps.ViisonShippingCommonOrder.view.detail.Tab',

    /**
     * List of short aliases for class names. Most useful for defining xtypes for widgets.
     */
    alias: 'widget.order-viison-ups-tab',

    /**
     * An optional extra CSS class that will be added to this component's Element.
     */
    cls: Ext.baseCSSPrefix + 'order-viison-ups-tab',

    /**
     * Contains all snippets for the view component.
     */
    title: '{s name="tab/title"}{/s}',

    /**
     * @Override from ShippingCommon
     */
    adapterSupportsBottomToolbar: true,

    constructor: function () {
        // Load custom stores
        this.packagingTypeStore = Ext.create('Shopware.apps.ViisonUPSShipping.store.PackagingType').load();

        this.callParent(arguments);
    },

});
