// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default form, the CRUD methods for the UPS mapping are added
 * to the default save button event.
 */
//{namespace name="backend/viison_ups/shipping"}
Ext.define('Shopware.apps.ViisonUPSShipping.controller.Tab', {

    /**
     * Extend the shipping tab controller from the ShippingCommon module
     */
    extend: 'Shopware.apps.ViisonShippingCommonShipping.controller.Tab',

    /**
     * Plugin-specific properties required by the parent class
     */
    tabAlias: 'shipping-viison-ups-tab',
    productStoreClass: 'Shopware.apps.ViisonUPSShipping.store.Product',
    productMappingStoreClass: 'Shopware.apps.ViisonUPSShipping.store.ProductMapping',
    productMappingModelClass: 'Shopware.apps.ViisonUPSShipping.model.ProductMapping',
    dispatchServiceProviderName: 'UPS'

});
