// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * The store handling all Product objects.
 */
Ext.define('Shopware.apps.ViisonUPSShipping.store.PackagingType', {

    /**
     * Extend from the standard ExtJS 4.
     */
    extend: 'Ext.data.Store',

    /**
     * The id used to find the store in the application.
     */
    storeId: 'viison-ups-packaging-type-store',

    /**
    * Define the used model for this store.
    */
    model: 'Shopware.apps.ViisonUPSShipping.model.PackagingType',

    /**
     * Sorters to sort the list elements automatically.
     */
    sorters: [
        {
            property: 'code',
            direction: 'ASC'
        }
    ],

    proxy: {
        type: 'ajax',
        url: '{url controller="ViisonUPSShipping" action="getPackagingTypes"}',
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total'
        }
    }

});
