// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

//{namespace name="backend/viison_ups_shipping/shipping"}
Ext.define('Shopware.apps.ViisonUPSShipping.view.edit.MappingPanel', {

    extend: 'Shopware.apps.ViisonShippingCommonShipping.view.edit.MappingPanel',

    /**
     * Contains all snippets for the view component.
     */
    customSnippets: {
        items: {
            higherInsurance: {
                label: '{s name="mapping_panel/items/higher_insurance/label"}{/s}',
                help: '{s name="mapping_panel/items/higher_insurance/help"}{/s}'
            },
            additionalHandlingRequired: {
                label: '{s name="mapping_panel/items/additional_handling_required/label"}{/s}',
                help: '{s name="mapping_panel/items/additional_handling_required/help"}{/s}'
            }
        }
    },

    /**
     * @override
     */
    getItems: function() {
        var me = this;
        return me.callParent(arguments). concat([
            me.createHigherInsuranceCheckbox(),
            me.createAdditionalHandlingCheckbox()
        ]);
    },

    /**
     * Creates a checkbox to configure the personal handover service option.
     *
     * @return The created checkbox item.
     */
    createHigherInsuranceCheckbox: function() {
        var me = this;
        return {
            xtype: 'checkbox',
            name: 'higherInsurance',
            fieldLabel: me.customSnippets.items.higherInsurance.label,
            helpText: me.customSnippets.items.higherInsurance.help,
            required: false,
            checked: false
        };
    },

    /**
     * Creates a checkbox to configure the additional handling service option.
     *
     * @return The created checkbox item.
     */
    createAdditionalHandlingCheckbox: function() {
        var me = this;
        return {
            xtype: 'checkbox',
            name: 'additionalHandlingRequired',
            fieldLabel: me.customSnippets.items.additionalHandlingRequired.label,
            helpText: me.customSnippets.items.additionalHandlingRequired.help,
            required: false,
            checked: false
        };
    }

});