<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\FileSystemExceptions;

class DirectoryNotReadableException extends AbstractFileSystemException
{
    /**
     * @param string $path path to directory
     * @param \Exception|null $previousException
     */
    public function __construct($path, \Exception $previousException = null)
    {
        parent::__construct(
            sprintf(
                'Directory \'%s\' is not readable. Please check if the directory exists and the permissions are correct. %s',
                $path,
                $previousException ? $previousException->getMessage() : ''
            ),
            $path,
            $previousException
        );
        $this->setSnippetName('directoryNotReadable');
    }
}
