<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions;

use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\LocalizableThrowable;
use Shopware\Plugins\ViisonCommon\Components\ExceptionTranslation\MessageLocalization;

class LocalizedException extends \Exception implements LocalizableThrowable
{
    use MessageLocalization;

    /**
     * @param string $snippetName
     * @param string $snippetNamespace
     * @param string $fallbackMessage
     * @param array $snippetArguments
     * @param \Exception|null $previousException
     */
    public function __construct($snippetName, $snippetNamespace, $fallbackMessage, array $snippetArguments = [], \Exception $previousException = null)
    {
        parent::__construct($fallbackMessage, 0, $previousException);
        $this->snippetName = $snippetName;
        $this->snippetNamespace = $snippetNamespace;
        $this->snippetArguments = $snippetArguments;
    }

    /**
     * @param \Exception $e
     * @param string $snippetName
     * @param string $snippetNamespace
     * @param array $snippetArguments
     * @return LocalizedException
     */
    public static function localize(\Exception $e, $snippetName, $snippetNamespace, array $snippetArguments = [])
    {
        return new self($snippetName, $snippetNamespace, $e->getMessage(), $snippetArguments, $e);
    }
}
