<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Exceptions\ValidationExceptions;

use Exception;

class ParameterHasWrongFormatException extends AbstractValidationException
{
    /**
     * @param string $parameterName
     * @param string $expectedFormat
     * @param Exception|null $previousException
     */
    public function __construct($parameterName, $expectedFormat, Exception $previousException = null)
    {
        $message = sprintf(
            'Parameter "%s" has wrong format. Expected format: %s',
            $parameterName,
            $expectedFormat
        );

        parent::__construct(
            $message,
            'parameterHasWrongFormatException',
            [
                $parameterName,
                $expectedFormat,
            ],
            $previousException
        );
    }
}
