<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes\Installation;

class ExpiringLockStatus extends LockStatus
{
    /**
     * @var int Time in seconds until the lock gets released automatically
     */
    private $remainingLockTimeInSeconds;

    /**
     * @param boolean $acquired
     * @param string $description
     * @param int $remainingLockTimeInSeconds
     */
    public function __construct($acquired, $description, $remainingLockTimeInSeconds)
    {
        parent::__construct($acquired, $description);
        $this->remainingLockTimeInSeconds = $remainingLockTimeInSeconds;
    }

    /**
     * @return int Time in seconds until the lock gets released automatically
     */
    public function getRemainingLockTimeInSeconds()
    {
        return $this->remainingLockTimeInSeconds;
    }
}
