<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Classes;

class TryWithFinally
{

    /**
     * Runs $tryFn and then $finallyFn, even if $tryFn threw an exception.
     * @return mixed the return value of $tryFn
     * @todo Remove once we can depend on PHP >= 5.5.
     */
    public static function tryWithFinally(callable $tryFn, callable $finallyFn)
    {
        try {
            $returnValue = $tryFn();
        } catch (\Exception $e) {
            $finallyFn();
            throw $e;
        }
        $finallyFn();

        return $returnValue;
    }
}
