<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Components\Migration;

/**
 * Migration holds the plain code (the instructions) of your migration.
 */
interface Migration
{
    /**
     * @return bool True, if the migration can be executed on the current system state, otherwise false.
     */
    public function canExecute();

    /**
     * Executes the migration.
     *
     * You need no idempotency check when implementing this interface. The migration framework will ensure that the
     * migration is executed only once. However, if your migration is non-atomic - this means it may make some
     * persistent changes before failing - you still need to ensure it is idempotent with regard to multiple retries,
     * including possible max_execution_time  violations.
     *
     * Throw an exception in every case of error. Return nothing on success.
     *
     * @param MigrationTranscript $transcript A transcript for logging and sending messages to the user.
     */
    public function execute(MigrationTranscript $transcript);
}
