<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Controllers\ViisonCommonBaseController;

class Shopware_Controllers_Backend_ViisonCommonStatusTranslator extends ViisonCommonBaseController
{
    /**
     * @var string
     */
    const PAYMENT_STATUS_NAMESPACE = 'backend/static/payment_status';

    /**
     * @var string
     */
    const ORDER_STATUS_NAMESPACE = 'backend/static/order_status';

    /**
     * @inheritdoc
     */
    public function getViewParams()
    {
        $paymentStatusSnippets = $this->get('snippets')->getNamespace(self::PAYMENT_STATUS_NAMESPACE)->toArray();
        $orderStatusSnippets = $this->get('snippets')->getNamespace(self::ORDER_STATUS_NAMESPACE)->toArray();

        return [
            'paymentStatusSnippets' => $paymentStatusSnippets,
            'orderStatusSnippets' => $orderStatusSnippets,
        ];
    }
}
