<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

if (!class_exists('ViisonCommon_Plugin_BootstrapV3')) {
    require_once('PluginBootstrapV3.php');
}

use Shopware\Plugins\ViisonCommon\Classes\Installation\PluginStructureIntegrity;

/**
 * Version 4 of the common plugin Bootstrap class. This version is based on ViisonCommon_Plugin_BootstrapV3
 * and provides an extra method for removing obsolete plugin files upon successful update.
 *
 * This class needs to be manually loaded in the respective plugin via:
 *
 * if (!class_exists('ViisonCommon_Plugin_BootstrapV4')) {
 *     require_once('ViisonCommon/PluginBootstrapV4.php');
 * }
 */
class ViisonCommon_Plugin_BootstrapV4 extends ViisonCommon_Plugin_BootstrapV3
{
    /**
     * Removes all obsolete plugin files using the PluginStructureIntegrity class.
     *
     * Usage: Call this method once after a successful! plugin update.
     */
    protected function removeObsoletePluginFiles()
    {
        try {
            // Remove obsolete plugin files
            $pluginIntegrity = new PluginStructureIntegrity($this->Path(), $this->get('pluginlogger'));
            $pluginIntegrity->removeObsoleteFiles();
        } catch (\Exception $e) {
            $this->get('pluginlogger')->error($this->getName() . ': Failed to remove obsolete plugin files.', ['exception' => $e]);
        }
    }
}
