<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

use Shopware\Plugins\ViisonCommon\Classes\Plugins\SwagSecurity\RedeclareClassErrorHotifx;

if (!class_exists('ViisonCommon_Plugin_BootstrapV6')) {
    require_once('PluginBootstrapV6.php');
}

/**
 * Version 7 of the common plugin Bootstrap class. This version is based on ViisonCommon_Plugin_BootstrapV6. It
 * implements a hotfix for the SwagSecurity redeclare class error.
 *
 * This class needs to be manually loaded in the plugin:
 *
 * if (!class_exists('ViisonCommon_Plugin_BootstrapV7')) {
 *     require_once('ViisonCommon/PluginBootstrapV7.php');
 * }
 */
class ViisonCommon_Plugin_BootstrapV7 extends ViisonCommon_Plugin_BootstrapV6
{
    /**
     * Add SwagSecurity redeclare class hotfix.
     *
     * @param $version
     * @return array|string|void
     * @throws \Doctrine\ORM\ORMException
     */
    public function update($version)
    {
        $this->preventRedeclareClassError();

        return parent::update($version);
    }

    /**
     * Add SwagSecurity redeclare class hotfix.
     *
     * @return array|bool
     * @throws \Doctrine\ORM\ORMException
     */
    public function uninstall()
    {
        $this->preventRedeclareClassError();

        return parent::uninstall();
    }

    /**
     * Executes SwagSecurity redeclare class hotfix.
     *
     * @throws \Doctrine\ORM\ORMException
     */
    protected function preventRedeclareClassError()
    {
        $redeclareClassHotfix = new RedeclareClassErrorHotifx(
            $this->get('models'),
            $this->collection->Application()->Container()->getParameter('kernel.root_dir')
        );
        $redeclareClassHotfix->preventRedeclareClassError();
    }
}
