<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonCommon\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonCommon\Components\TemplateMailServiceDecorator;

class ServiceDecorationSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Bootstrap_AfterInitResource_templatemail' => 'onAfterInitTemplateMail',
        ];
    }

    /**
     * Decorates the 'templatemail' service by replacing it with our hookable sub class.
     *
     * @param \Enlight_Event_EventArgs $args
     */
    public function onAfterInitTemplateMail(\Enlight_Event_EventArgs $args)
    {
        $args->get('subject')->set(
            'templatemail',
            TemplateMailServiceDecorator::decorate($args->get('subject')->get('templatemail'))
        );
    }
}
