// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * Abstract base class for analysis modules. Enables easily using the decorator pattern (via nextModuleHandler).
 */
Ext.define('Shopware.apps.ViisonCommonAnalytics.controller.AnalysisModuleHandler', {

    nextModuleHandler: null,

    constructor: function (config) {
        this.nextModuleHandler = config.nextModuleHandler || null;
        this.callParent(arguments);
    },

    onLeaveAnalysis: function () {
        if (this.nextModuleHandler !== null) {
            return this.nextModuleHandler.onLeaveAnalysis.apply(this.nextModuleHandler, arguments);
        }

        return undefined;
    },

    onBeforeRenderDataOutput: function () {
        if (this.nextModuleHandler !== null) {
            return this.nextModuleHandler.onBeforeRenderDataOutput.apply(this.nextModuleHandler, arguments);
        }

        return undefined;
    },

    onBuildRequestParamMap: function (mainController, analysis, paramMap) {
        if (this.nextModuleHandler !== null) {
            return this.nextModuleHandler.onBuildRequestParamMap.apply(this.nextModuleHandler, arguments);
        }

        return paramMap;
    },

});
